//
//  GSAnchor.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.8.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSElement.h>
#import <GlyphsCore/GSUserDataProtocol.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(uint8_t, GSAnchorType) {
	BaseAnchor = 0,
	MarkAnchor = 1
};

/// The class defining the anchor object

@interface GSAnchor : GSElement <NSCoding, NSCopying, GSUserDataProtocol> {
	NSString *_name;
}

/// Name of the anchor.
@property (copy, nonatomic) NSString *name;

@property (strong, nonatomic) NSString *context;

- (BOOL)isEqualToAnchor:(GSAnchor *)other;

- (void)setNameFast:(NSString *)name;

@end

NS_ASSUME_NONNULL_END
